/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.common;

import com.ibm.hsc.websm.cec.CECMObject;
import com.ibm.websm.diagnostics.IDebug;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class WSMCommonUtil {
    public static final String R4_NAMESPACE = "root/ibmhscV3_2";
    public static final String R5_NAMESPACE = "root/ibmhscS1_0";
    public static final String NAME_SPACE = "nameSpace_Prop";
    public static final String ERROR_PREFIX = "@@@@@@@ERROR: ";
    public static final String DEBUG_PREFIX = "#######Info: ";
    public static final String STAR = "*";
    public static final String SLASH = "/";
    private static final String WEBSM_CLASS = "com.ibm.hsc.websm.";
    public static final String CEC_MO_CLASS_NAME = "com.ibm.hsc.websm.cec.CECMObject";
    public static final String FRAME_MO_CLASS_NAME = "com.ibm.hsc.websm.frame.FrameMObject";
    public static final String LPAR_MO_CLASS_NAME = "com.ibm.hsc.websm.lpar.LPARMObject";
    public static final String LPAR_GROUP_MO_CLASS_NAME = "com.ibm.hsc.websm.grouping.PartitionGroup";
    public static final String PROFILE_MO_CLASS_NAME = "com.ibm.hsc.websm.profile.ProfileMObject";
    public static final String SYS_PROFILE_MO_CLASS_NAME = "com.ibm.hsc.websm.sysprofile.SysProfileMObject";
    public static final String SYS_PROFILE_GROUP_MO_CLASS_NAME = "com.ibm.hsc.websm.grouping.SysProfileGroup";
    private static final String DB_STRING = "com.ibm.hsc.websm.common.WSMCommonUtil>>";

    public static String[] getSupportedNameSpaces() {
        String[] stringArray = new String[]{R5_NAMESPACE};
        return stringArray;
    }

    public static boolean isR5(String string) {
        boolean bl = false;
        if (string != null && string.equals(R5_NAMESPACE)) {
            bl = true;
        }
        return bl;
    }

    public static String getLparNameSpace(String string) {
        int n = string.indexOf("~");
        String string2 = n > 0 ? string.substring(0, n) : string;
        String string3 = string2.substring(string2.indexOf(STAR) + 1);
        String string4 = string3 + "~" + "IBMHSC_ComputerSystem" + "~";
        if (IDebug.enabled()) {
            System.err.println("com.ibm.hsc.websm.common.WSMCommonUtil>>getLparNameSpace: \nlparId = " + string2 + " cecName = " + string4 + "\nCECMObject Hashtable contents are: " + CECMObject.ID_NAMESPACE.toString());
        }
        String string5 = (String)CECMObject.ID_NAMESPACE.get(string4);
        return string5;
    }

    public static String getCecNameSpace(String string) {
        if (IDebug.enabled()) {
            System.err.println("com.ibm.hsc.websm.common.WSMCommonUtil>>getCecNameSpace()>>>>> cecKey : " + string + "CECMObject ID_NAMESPACE : \n" + CECMObject.ID_NAMESPACE.toString());
        }
        return (String)CECMObject.ID_NAMESPACE.get(string);
    }

    public static String getSysProfNameSpace(String string) {
        String string2;
        block5: {
            if (IDebug.enabled()) {
                System.err.println("com.ibm.hsc.websm.common.WSMCommonUtil>>getSysProfNameSpace()>>>>> profKey : " + string + "CECMObject ID_NAMESPACE : \n" + CECMObject.ID_NAMESPACE.toString());
            }
            string2 = "";
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "~", true);
                if (stringTokenizer != null) {
                    while (stringTokenizer.countTokens() > 4) {
                        string2 = string2 + stringTokenizer.nextToken();
                    }
                }
            }
            catch (Throwable throwable) {
                if (!IDebug.enabled()) break block5;
                System.err.println("com.ibm.hsc.websm.common.WSMCommonUtil>>getSysProfNameSpace()>>> : Throwable caught...");
                throwable.printStackTrace();
            }
        }
        return (String)CECMObject.ID_NAMESPACE.get(string2);
    }

    public static Short convertUint(UnsignedInt8 unsignedInt8) {
        if (unsignedInt8 == null) {
            return null;
        }
        return new Short(unsignedInt8.shortValue());
    }

    public static Integer convertUint(UnsignedInt16 unsignedInt16) {
        if (unsignedInt16 == null) {
            return null;
        }
        return new Integer(unsignedInt16.intValue());
    }

    public static Long convertUint(UnsignedInt32 unsignedInt32) {
        if (unsignedInt32 == null) {
            return null;
        }
        return new Long(unsignedInt32.longValue());
    }

    public static Integer[] convertUint(UnsignedInt16[] unsignedInt16Array) {
        if (unsignedInt16Array == null) {
            return null;
        }
        Integer[] integerArray = new Integer[unsignedInt16Array.length];
        for (int i = 0; i < unsignedInt16Array.length; ++i) {
            integerArray[i] = WSMCommonUtil.convertUint(unsignedInt16Array[i]);
        }
        return integerArray;
    }

    public static Short[] convertUint(UnsignedInt8[] unsignedInt8Array) {
        if (unsignedInt8Array == null) {
            return null;
        }
        Short[] shortArray = new Short[unsignedInt8Array.length];
        for (int i = 0; i < unsignedInt8Array.length; ++i) {
            shortArray[i] = WSMCommonUtil.convertUint(unsignedInt8Array[i]);
        }
        return shortArray;
    }

    public static Long[] convertUint(UnsignedInt32[] unsignedInt32Array) {
        if (unsignedInt32Array == null) {
            return null;
        }
        Long[] longArray = new Long[unsignedInt32Array.length];
        for (int i = 0; i < unsignedInt32Array.length; ++i) {
            longArray[i] = WSMCommonUtil.convertUint(unsignedInt32Array[i]);
        }
        return longArray;
    }

    public static Vector parseProfileKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "~", false);
        Vector<String> vector = new Vector<String>(0);
        String string2 = stringTokenizer.nextToken();
        int n = string2.indexOf(STAR);
        if (n > 0) {
            vector.add(string2);
            vector.add(string2.substring(0, n));
            vector.add(string2.substring(n + 1));
        }
        string2 = stringTokenizer.nextToken();
        vector.add(stringTokenizer.nextToken());
        return vector;
    }

    public static String getLparKey(String string) {
        String string2 = "";
        Vector vector = WSMCommonUtil.parseProfileKey(string);
        string2 = (String)vector.elementAt(0);
        string2 = string2 + "~" + "IBMHSC_Partition" + "~";
        return string2;
    }

    public static String getSysProfId(String string) {
        String string2;
        block4: {
            string2 = null;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "~", false);
                if (stringTokenizer != null) {
                    while (stringTokenizer.countTokens() > 1) {
                        stringTokenizer.nextToken();
                    }
                    string2 = stringTokenizer.nextToken();
                }
            }
            catch (Throwable throwable) {
                if (!IDebug.enabled()) break block4;
                System.err.println("com.ibm.hsc.websm.common.WSMCommonUtil>>getSysProfId()>>>>> : Throwable caught.....");
                throwable.printStackTrace();
            }
        }
        return string2;
    }

    public static final String timeStamp() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(14);
        String string = new Integer(calendar.get(14)).toString();
        if (1 == string.length()) {
            string = "00" + string;
        } else if (2 == string.length()) {
            string = "0" + string;
        }
        return calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + "." + string;
    }
}

